<?php
@session_start();
if(isset($_SESSION['cart'])){
  $count_carts = count($_SESSION['cart']);
}else{
  $count_carts = 0;
}
include("modules/db.php");
include("modules/products.php");
$product = new Products();
$product_type = $product->getProductMenu();

?>


<!DOCTYPE html>
<html
  lang="en"
  class="light-style layout-menu-fixed"
  dir="ltr"
  data-theme="theme-default"
  data-assets-path="../assets/"
  data-template="vertical-menu-template-free"
>
  <head>
    <meta charset="utf-8" />
    <meta
      name="viewport"
      content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0"
    />

   <title>iTmecom</title>

    <meta name="description" content="" />

    <!-- Favicon 
    <link rel="icon" type="image/x-icon" href="../assets/img/favicon/favicon.ico" />
-->
    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com" />
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
    <link
      href="https://fonts.googleapis.com/css2?family=Public+Sans:ital,wght@0,300;0,400;0,500;0,600;0,700;1,300;1,400;1,500;1,600;1,700&display=swap"
      rel="stylesheet"
    />

    <!-- Icons. Uncomment required icon fonts -->
    <link rel="stylesheet" href="../assets/vendor/fonts/boxicons.css" />

    <!-- Core CSS -->
    <link rel="stylesheet" href="../assets/vendor/css/core.css" class="template-customizer-core-css" />
    <link rel="stylesheet" href="../assets/vendor/css/theme-default.css" class="template-customizer-theme-css" />
    <link rel="stylesheet" href="../assets/css/demo.css" />

    <!-- Vendors CSS -->
    <link rel="stylesheet" href="../assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.css" />

    <link rel="stylesheet" href="../assets/vendor/libs/apex-charts/apex-charts.css" />

    <!-- Page CSS -->

    <!-- Helpers -->
    <script src="../assets/vendor/js/helpers.js"></script>

    <!--! Template customizer & Theme config files MUST be included after core stylesheets and helpers.js in the <head> section -->
    <!--? Config:  Mandatory theme config file contain global vars & default theme options, Set your preferred theme option in this file.  -->
    <script src="//cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script src="../assets/js/config.js"></script>
    <script src="../assets/js/function.js"></script>
    <style type="text/css">
      #page-loading {
        position: fixed;
        top: 0;
        left: 0;
        bottom: 0;
        right: 0;
        z-index: 9999;
    }
    .waiting-cate {
        display: none;
        position: fixed;
        z-index: 9000;
        top: 0;
        left: 0;
        height: 100%;
        width: 100%;
        background: rgba(255,255,255,.8);
    }
    .text-three-balls {
        margin: 0 auto;
        width: 150px;
        text-align: center;
        position: absolute;
        left: 0;
        right: 0;
        top: 30%;
        color: #0060AD;
        font-family: DBHeavent-Bold;
        font-size: 48px;
    }
    .three-balls .ball1 {
        -webkit-animation-delay: -.16s;
        animation-delay: -.16s;
    }
    .three-balls .ball {
        position: relative;
        width: 20px;
        height: 20px;
        border-radius: 50%;
        display: inline-block;
        background-color: #696cff;
       animation: bouncedelay 2.0s infinite cubic-bezier(.62, .28, .23, .99) both;
    }
    .three-balls .ball2 {
        -webkit-animation-delay: -.08s;
        animation-delay: -.08s;
    }
    @keyframes  bouncedelay {
  0% {
    bottom: 0;
    background-color: #10bf5b;
  }
  16.66% {
    bottom: 40px;
    background-color: #0039aa;
  }
  33.33% {
    bottom: 0px;
    background-color: #0039aa;
  }
  50% {
    bottom: 40px;
    background-color: #2294fc;
  }
  66.66% {
    bottom: 0px;
    background-color: #2294fc;
  }
  83.33% {
    bottom: 40px;
    background-color: #10bf5b;
  }
  100% {
    bottom: 0;
    background-color: #10bf5b;
  }
}

@-webkit-keyframes bouncedelay {
  0% {
    bottom: 0;
    background-color: #10bf5b;
  }
  16.66% {
    bottom: 40px;
    background-color: #0039aa;
  }
  33.33% {
    bottom: 0px;
    background-color: #0039aa;
  }
  50% {
    bottom: 40px;
    background-color: #2294fc;
  }
  66.66% {
    bottom: 0px;
    background-color: #2294fc;
  }
  83.33% {
    bottom: 40px;
    background-color: #10bf5b;
  }
  100% {
    bottom: 0;
    background-color: #10bf5b;
  }
}
    .three-balls {
        margin: 0 auto;
        width: 100px;
        text-align: center;
        position: absolute;
        left: 0;
        right: 0;
        top: 45%;
    }
    .menu-header {
        background: #0060ad;
        background: -moz-linear-gradient(90deg,rgba(0,96,173,1) 0%,rgba(0,96,173,1) 60%,rgba(37,220,244,1) 100%);
        background: -webkit-linear-gradient(90deg,rgba(0,96,173,1) 0%,rgba(0,96,173,1) 60%,rgba(37,220,244,1) 100%);
        background: linear-gradient(90deg,rgba(0,96,173,1) 0%,rgba(0,96,173,1) 60%,rgba(37,220,244,1) 100%);
        filter: progid:DXImageTransform.Microsoft.gradient(startColorstr="#0060ad",endColorstr="#25dcf4",GradientType=1);
        height: 35px;
        position: relative;
    }
    .btn-cart {
       margin-left: 10px;
        width: 36px;
        height: 36px;
        border-radius: 10px;
        border: none;
        position: relative;
        box-shadow: 0 2px 5px rgba(0,0,0,0.4);
    }

    .btn-cart:before {
        content: attr(data-count);
        width: 18px;
        height: 18px;
        line-height: 18px;
        text-align: center;
        display: block;
        border-radius: 50%;
        background-color: red;
        border: 1px solid #FFF;
        box-shadow: 0 1px 3px rgba(0,0,0,0.4);
        color: #FFF;
        position: absolute;
        top: -7px;
        left: -7px;
    }

    .btn-cart.badge-bottom-right:before {
        left: auto;
        top: auto;
        right: -7px;
        bottom: -7px;
    }

    </style>
  </head>

  <body>
    <!-- Layout wrapper -->
    <div class="layout-wrapper layout-content-navbar">
      <div class="layout-container">
        <!-- Menu -->

        <aside id="layout-menu" class="layout-menu menu-vertical menu bg-menu-theme">
          <div class="app-brand demo">
            <a href="index.php" class="app-brand-link">
              <img width="100%" src="assets/img/logo.png">
             
            </a>

            <a href="javascript:void(0);" class="layout-menu-toggle menu-link text-large ms-auto d-block d-xl-none">
              <i class="bx bx-chevron-left bx-sm align-middle"></i>
            </a>
          </div>
          <hr>
          

          <ul class="menu-inner py-1">
             <li style="color: #fff" class="menu-item">
				   
				  <form >
					  <select onchange="changeCurrency(this)" class="form-control">
						   <option value="MMK" <?php if($_SESSION['currency']=="MMK"){ echo 'selected="selected"';} ?>>Currency MMK</option>
						  <option value="THB" <?php if($_SESSION['currency']=="THB"){ echo 'selected="selected"';} ?>>Currency THB</option>
						 
					  </select>
				  </form>
			  </li>
            <?php
            foreach ($product_type as $key => $value) {
              ?>
                  <li style="color: #fff" class="menu-header small text-uppercase">
                    <span class="menu-header-text"><?=$value->name?></span>
                  </li>
              <?php
              foreach ($value->category as $key => $category) {
                ?>
                  <li class="menu-item">
                    <a href="javascript:void(0);" class="menu-link menu-toggle">
                      <div><?=$category->category_name?></div>
                    </a>
                    <ul class="menu-sub">
                      <?php
                        foreach ($category->sub_category as $key => $sub_category) {
                          ?>
                            <li class="menu-item">
                              <a onclick="product_list('<?=$category->category_name?>','<?=$sub_category->id?>','<?=$sub_category->sub_category_name?>')" href="javascript:void(0);" class="menu-link">
                                <div data-i18n="Basic"><?=$sub_category->sub_category_name?></div>
                              </a>
                            </li>
                          <?php
                        }
                      ?>
                    </ul>
                  </li>
                <?php
              }
            }
            ?>
           
            
          </ul>
        </aside>
        <!-- / Menu -->

        <!-- Layout container -->
        <div class="layout-page">
          <!-- Navbar -->

          <nav
            class="layout-navbar container-xxl navbar navbar-expand-xl navbar-detached align-items-center bg-navbar-theme"
            id="layout-navbar"
          >
            <div class="layout-menu-toggle navbar-nav align-items-xl-center me-3 me-xl-0 d-xl-none">
              <a class="nav-item nav-link px-0 me-xl-4" href="javascript:void(0)">
                <i class="bx bx-menu bx-sm"></i>
              </a>
            </div>

            <div class="navbar-nav-right d-flex align-items-center" id="navbar-collapse">
              <!-- Search -->
              <div class="navbar-nav align-items-center" style="width: 100%">
                <div class="nav-item d-flex align-items-center" style="width: 99%">
                  
                  <input
                    id="search_product"
                    type="text"
                    name="search_product"
                    class="form-control border-0 shadow-none"
                    placeholder="Search..."
                    aria-label="Search..."
                    style="background-color: #5759df21"

                  /> 
                  
                  </a>
                </div>
              </div>
              <!-- /Search -->

              <ul class="navbar-nav flex-row align-items-center ms-auto">
                <!-- User -->
                <li class="nav-item navbar-dropdown dropdown-user dropdown">
                  <div id="div-cart-btn">
                    <button id="btn-cart" onclick="page_cart()" style="color:#fff"  data-count="<?=$count_carts?>" class="bg-primary btn-cart badge-bottom-right">
                      <i class="bx bx-cart">
                        </i>
                    </button>
                  </div>
                  
                  
                  <!-- <ul class="dropdown-menu dropdown-menu-end">
                    <li>
                      <a class="dropdown-item" href="#">
                        <div class="d-flex">
                          <div class="flex-shrink-0 me-3">
                            <div class="avatar avatar-online">
                              <img src="../assets/img/avatars/1.png" alt class="w-px-40 h-auto rounded-circle" />
                            </div>
                          </div>
                          <div class="flex-grow-1">
                            <span class="fw-semibold d-block">John Doe</span>
                            <small class="text-muted">Admin</small>
                          </div>
                        </div>
                      </a>
                    </li>
                    <li>
                      <div class="dropdown-divider"></div>
                    </li>
                    <li>
                      <a class="dropdown-item" href="#">
                        <i class="bx bx-user me-2"></i>
                        <span class="align-middle">My Profile</span>
                      </a>
                    </li>
                    <li>
                      <a class="dropdown-item" href="#">
                        <i class="bx bx-cog me-2"></i>
                        <span class="align-middle">Settings</span>
                      </a>
                    </li>
                    <li>
                      <a class="dropdown-item" href="#">
                        <span class="d-flex align-items-center align-middle">
                          <i class="flex-shrink-0 bx bx-credit-card me-2"></i>
                          <span class="flex-grow-1 align-middle">Billing</span>
                          <span class="flex-shrink-0 badge badge-center rounded-pill bg-danger w-px-20 h-px-20">4</span>
                        </span>
                      </a>
                    </li>
                    <li>
                      <div class="dropdown-divider"></div>
                    </li>
                    <li>
                      <a class="dropdown-item" href="auth-login-basic.html">
                        <i class="bx bx-power-off me-2"></i>
                        <span class="align-middle">Log Out</span>
                      </a>
                    </li>
                  </ul> -->
                </li>
                <!--/ User -->
              </ul>
            </div>
          </nav>

          <!-- / Navbar -->
